#!/bin/sh

# luna firmware upgrade  script
# $1 image destination (0 or 1) 
# Kernel and root file system images are assumed to be located at the same directory named uImage and rootfs respectively
# ToDo: use arugements to refer to kernel/rootfs location.

k_img="uImage"
r_img="rootfs"
img_ver="fwu_ver"
md5_cmp="md5.txt"
md5_cmd="/bin/md5sum"
#md5 run-time result
md5_tmp="md5_tmp" 
md5_rt_result="md5_rt_result.txt"
cdtcfg="custom.cdtCfg"
cfgTmp="/tmp/cdt_custom.config"
fl_kernel1_sz=`nv getenv fl_kernel1_sz | awk -F= '{print $2}'`
fl_kernel2_sz=`nv getenv fl_kernel2_sz | awk -F= '{print $2}'`
sw_version0_val=$(nv getenv sw_version0)
sw_version0_val=${sw_version0_val#*=}
echo "$sw_version0_val"
myEcho()
{
	if [ -f /tmp/busybox ]; then
		/tmp/busybox echo $1 $2 $3 $4 $5 $6 $7 $8 $9
		/tmp/busybox logger $1 $2 $3 $4 $5 $6 $7 $8 $9
	else
		echo $1 $2 $3 $4 $5 $6 $7 $8 $9
		logger $1 $2 $3 $4 $5 $6 $7 $8 $9
	fi

}

#for cdt config file
myEcho $cdtcfg file check
if [ "`tar -tf $2 $cdtcfg`" = "$cdtcfg" ]; then 
		myEcho "load $cdtcfg in flash"
		tar -xf $2 $cdtcfg $md5_cmp
		grep $cdtcfg $md5_cmp > $md5_tmp
		$md5_cmd $cdtcfg > $md5_rt_result
		diff $md5_rt_result $md5_tmp
if [ $? != 0 ]; then 
    myEcho "$cdtcfg md5_sum inconsistent, aborted image updating !"
    exit 1
fi
#Check Software Version Upgrade Limit
	/bin/cdtCfg -x $cdtcfg
	limitflag="`grep 0x00030013 $cfgTmp | awk '{print $3}`"
	logo="`grep 0x00030008 $cfgTmp | awk '{print $3}'`"
	region="`grep 0x00030012 $cfgTmp | awk '{print $3}`"
	locallogo="`flash get LOGO | sed s/^.*=.//g`"
	localregion="`flash get REGION | sed s/^.*=//g`"
	myEcho "check upgrade limit"
	if [ "$limitflag" -eq "2" ]; then
		if [ "$logo" = "$locallogo" ] && [ "$region" = "$localregion" ]; then
			myEcho "Allow the upgrade!limitFlag=$limitflag"
		else
			myEcho "No allow the upgrade!limitFlag=$limitflag"
			exit 1
		fi
	elif [ "$limitflag" -eq "1" ]; then
		if [ "$logo" = "$locallogo" ]; then
			myEcho "Allow the upgrade!limitFlag=$limitflag"
		else
			myEcho "No allow the upgrade!limitFlag=$limitflag"
			exit 1
		fi
	else	
		myEcho "Allow the upgrade!limitFlag=$limitflag"
	fi
	cp $cdtcfg /var/config/$cdtcfg
		#/bin/cdtCfg -x /var/config/$cdtcfg
fi


# Stop this script upon any error
set -e

myEcho "Updating image $1 with file $2"

# Find out kernel/rootfs mtd partition according to image destination
k_mtd="/dev/"`cat /proc/mtd | grep \"k"$1"\" | sed 's/:.*$//g'`
r_mtd="/dev/"`cat /proc/mtd | grep \"r"$1"\" | sed 's/:.*$//g'`
myEcho "kernel image is located at $k_mtd"
myEcho "rootfs image is located at $r_mtd"

# Extract kernel image
tar -xf $2 $k_img -O | md5sum | sed 's/-/'$k_img'/g' > $md5_rt_result
# Check integrity
grep $k_img $md5_cmp > $md5_tmp
diff $md5_rt_result $md5_tmp

if [ $? != 0 ]; then
    echo "$k_img""md5_sum inconsistent, aborted image updating !"
    exit 1
fi

# Extract rootfs image
tar -xf $2 $r_img -O | md5sum | sed 's/-/'$r_img'/g' > $md5_rt_result
# Check integrity
grep $r_img $md5_cmp > $md5_tmp
diff $md5_rt_result $md5_tmp

if [ $? != 0 ]; then
    # rm $r_img
    myEcho "$r_img""md5_sum inconsistent, aborted image updating !"
    exit 1
fi

echo "Integrity of $k_img & $r_img is okay, start updating"

if [ "${fl_kernel1_sz}"X = "${fl_kernel2_sz}"X ]; then
	myEcho do nothing
else
	#logger "nv setenv trySw0Times 3"
	nv setenv trySw0Times 3
	nv setenv sw_commit 1
	#logger "nv setenv sw_tryactive 0"
	nv setenv sw_tryactive 0
	nv setenv sw_commit_later 0
	nv setenv sw_version1 "$sw_version0_val"
fi

if [ "${fl_kernel1_sz}"X = "${fl_kernel2_sz}"X ]; then
	echo do nothing
else
	logger "waitActiveImage start"
	###sleep 40 seconds max
	for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40
		do
		if [ -f /var/tmp/waitActiveImage ]; then
			echo waitActiveImage
			sleep 1
		else
			break
		fi
		done	
fi

myEcho "will force reboot by watchdog 70 second later"
### flash_eraseall and write cost about 28 seconds, auto reboot 70 second later
echo 70 >/proc/watchdog/reboot_time ; echo 3 > /proc/watchdog/watchdog_flag

# Erase kernel partition 
flash_eraseall $k_mtd
# Write kernel partition
myEcho "Writing $k_img to $k_mtd"
tar -xf $2 $k_img -O > $k_mtd

if [ "${fl_kernel1_sz}"X != "${fl_kernel2_sz}"X ]; then
    cp /bin/flash_eraseall /var/tmp/flash_eraseall
    cp /bin/busybox /tmp/busybox
fi

myEcho "Write image version information before erase rootfs"
# Write image version information 
tar -xf $2 $img_ver 
nv setenv sw_version"$1" "`cat $img_ver`"

myEcho Erase rootfs partition 
flash_eraseall $r_mtd
myEcho Write rootfs partition
myEcho "Writing $r_img to $r_mtd"
/tmp/busybox tar -xf $2 $r_img -O > $r_mtd

myEcho "Clean up temporary files"
# Clean up temporary files
/tmp/busybox rm -f $md5_cmp $md5_tmp $md5_rt_result $img_ver $2

# Post processing (for future extension consideration)

myEcho "Successfully updated image $1!!"
if [ "${fl_kernel1_sz}"X = "${fl_kernel2_sz}"X ]; then
	/tmp/busybox echo do nothing
else
	/tmp/busybox reboot -f
fi

